/* 
 * Copyright 2014 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.wlanconfiguration;

import java.io.IOException;
import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.soap.ISoapCredentials;

public class SetEnable extends WLANSoapHelper<Boolean>
{
	
	private boolean mEnable;
	
	/**
	 * Sets WLAN enabled
	 * 
	 * @param interfaceIndex
	 * 		Index of WLAN configuration interface
	 * @throws IllegalArgumentException
	 * 		illegal value of a member of mode 
	 */
	public SetEnable(ISoapCredentials soapCredentials, int interfaceIndex,
			boolean enable)
	{
		super(soapCredentials, interfaceIndex);
		
		mEnable = enable;
	}

	@Override
	public Boolean getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		// no out parameter, check for error response
		exceptOnFault(getSoapBody());
		return Boolean.TRUE;
	}

	@Override
	public String getSoapMethodParameter()
	{
		return "<NewEnable>" + Integer.toString((mEnable) ? 1 : 0) + "</NewEnable>";
	}

	@Override
	public String getSoapMethod()
	{
		return "SetEnable";
	}
}
