/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.appsetup;

import java.io.IOException;

import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.AppSetupConfig;
import de.avm.android.tr064.model.RightEnum;
import de.avm.android.tr064.soap.ISoapCredentials;

public class GetConfig extends AppSetupSoapHelper<AppSetupConfig>
{
    public GetConfig(ISoapCredentials soapCredentials)
    {
        super(soapCredentials);
    }

	@Override
	public AppSetupConfig getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
        String input = getSoapBody();

        AppSetupConfig appSetupConfig = new AppSetupConfig();
        try
        {
            appSetupConfig.setConfigRight(RightEnum.valueOf(getValueByName("NewConfigRight", input)));
            appSetupConfig.setAppRight(RightEnum.valueOf(getValueByName("NewAppRight", input)));
            appSetupConfig.setNasRight(RightEnum.valueOf(getValueByName("NewNasRight", input)));
            appSetupConfig.setPhoneRight(RightEnum.valueOf(getValueByName("NewPhoneRight", input)));
            appSetupConfig.setDialRight(RightEnum.valueOf(getValueByName("NewDialRight", input)));
            appSetupConfig.setHomeautoRight(
                    RightEnum.valueOf(getValueByName("NewHomeautoRight", input)));
        }
        catch (IllegalArgumentException exp)
        {
            throw new DataMisformatException(getInvalidResponseErrorMessage(), exp);
        }
        appSetupConfig.setInternetRights(getBooleanByName("NewInternetRights", input));
        appSetupConfig.setAccessFromInternet(getBooleanByName("NewAccessFromInternet", input));

        return appSetupConfig;
	}

	@Override
	public String getSoapMethod()
	{
		return "GetConfig";
	}
}