/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.fritzapp.com;

import de.avm.android.fritzapp.util.ResourceHelper;
import de.avm.android.tr064.exceptions.SslErrorException;
import android.content.Context;

public enum ConnectionProblem
{
	OK,
	
	WLAN_OFF, NETWORK_DISCONNECTED,
	
	FRITZBOX_MISSING, FRITZBOX_VERSION,
	FRITZBOX_PASSWORD, FRITZBOX_NOTR064,
	
	SSL_ERROR, CERTIFICATE_ERROR;
	
	private Exception mCause = null;
	
	public boolean isError()
	{
		switch (this)
		{
			case OK:
				return false;

			case WLAN_OFF:
			case NETWORK_DISCONNECTED:
			case FRITZBOX_MISSING:
				// no connection but not an error
				return false;
		}
		return true;
	}
	
	public Exception getCause()
	{
		return mCause;
	}
	
	public void setCause(Exception e)
	{
		mCause = e;
	}
	
	public String getDisplayMessage(Context context)
	{
		String message;
		if (((this == SSL_ERROR) || (this == CERTIFICATE_ERROR)) &&
				(mCause != null) && (mCause.getClass().equals(SslErrorException.class)))
			message = SslErrorException.getDisplayMessage(context, mCause);
		else
			message = ResourceHelper.getTextForConnectionProblem(this, context);
		return message;
	}
}
