/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

import android.os.Parcel;
import android.os.Parcelable;

/*
 *  Represents information on a TAM. As received from the Fritzbox 
 */
public class VoIPInfoEx implements Parcelable
{
	/*
		NewVoIPPasswordMinChars  Out  Int  min. length of password 
		NewVoIPPasswordMaxChars  Out  Int  max. length of password 
		NewVoIPPasswordAllowedChars  Out  String  chars allowed in passwords 
	*/

	private int mPasswordMinChar = 3;
	private int mPasswordMaxChar = 64;
	private String mPasswordAllowedChar = "";

	public VoIPInfoEx()
	{
	}
	
	public VoIPInfoEx(Parcel in)
	{
		mPasswordMinChar = in.readInt();
		mPasswordMaxChar = in.readInt();
		mPasswordAllowedChar = in.readString();
	}
	
	public void setPasswordMinChar(int min)
	{
		mPasswordMinChar = min;
	}

	public int getPasswordMinChar()
	{
		return mPasswordMinChar;
	}
	
	public void setPasswordMaxChar(int max)
	{
		mPasswordMaxChar = max;
	}

	public int getPasswordMaxChar()
	{
		return mPasswordMaxChar;
	}

	public void setPasswordAllowedChar(String allowed)
	{
		mPasswordAllowedChar = allowed;
	}

	public String getPasswordAllowedChar()
	{
		return mPasswordAllowedChar;
	}

	public int describeContents()
	{
		return 0;
	}

	public static final Parcelable.Creator<VoIPInfoEx> CREATOR =
			new Parcelable.Creator<VoIPInfoEx>()
	{
		public VoIPInfoEx createFromParcel(Parcel in)
		{
			return new VoIPInfoEx(in);
		}

		public VoIPInfoEx[] newArray(int size)
		{
			return new VoIPInfoEx[size];
		}
	};

	public void writeToParcel(Parcel out, int flags)
	{
		out.writeInt(mPasswordMinChar);
		out.writeInt(mPasswordMaxChar);
		out.writeString(mPasswordAllowedChar);
	}
}