/* 
 * Copyright 2010 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package org.sipdroid.media;

public class AudioFilterInterpolation extends AudioFilter  
{
	public AudioFilterInterpolation()
	{
		Init();
	}

	public void Init()
	{
		for(int i = 0; i < m_samples.length; ++i)
			m_samples[i] = 0;
	}

	// Konvertiert nSamples Samples im Format 8kHz-Mono-WAV aus *pData nach 16kHz-Mono-WAV und
	// legt diese in *pOut ab.
	public int Convert(short[] pData, int nSamples, short[] pOut)
	{
		/*---------------------------------------------------------------------------*\
		func:	filtert Daten von fs:fg 2:1  ==> 8 kHz --->  16 kHz
				Filter: FIR, 64 float-Koeffizienten
		note:	gefilterte Daten werden den OutputBuffer geschrieben
		\*---------------------------------------------------------------------------*/
		int out=0;

		for(int in=0; in < nSamples; ++in)
		{
			float sam1=0, sam2=0;
			for(int i = 0; i < (m_samples.length - 1); ++i)
			{
				final float x8k = m_samples[i] = m_samples[i + 1];
				sam1 += x8k * c_koeffizienten[DEZIMATION_FILTER_LEN - 2*i -2 ];
				sam2 += x8k * c_koeffizienten[DEZIMATION_FILTER_LEN - 2*i -1 ];
			}
			final float x8k = m_samples[m_samples.length - 1] = pData[in];
			sam1 += x8k * c_koeffizienten[0];
			sam2 += x8k * c_koeffizienten[1];
			
			pOut[out++] = AudioFilter.float2short(sam1);
			pOut[out++] = AudioFilter.float2short(sam2);
		}
		assert(out == pOut.length);
		return out;
	}

	protected short [] m_samples = new short[(DEZIMATION_FILTER_LEN / 2) + 1];
}
