/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.fritzapp.service;

import de.avm.android.fritzapp.sipua.ui.Sipdroid;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;

/**
 * Receiver to start app's service on device startup
 */
public class BootCompletedReceiver extends BroadcastReceiver
{
	private static final long AUTOSTART_DELAY = 30000; // ms
	
	@Override
	public void onReceive(Context context, Intent intent)
	{
        if (intent.getAction().equals(Intent.ACTION_BOOT_COMPLETED) &&
        		Sipdroid.on(context))
        {
        	PendingIntent pendingIntent = PendingIntent.getService(context, 0,
        			new Intent(context, BoxService.class), 0);

			AlarmManager alarmManager = (AlarmManager)context
					.getSystemService(Context.ALARM_SERVICE);
			alarmManager.cancel(pendingIntent);
			alarmManager.set(AlarmManager.ELAPSED_REALTIME_WAKEUP,
					SystemClock.elapsedRealtime() + AUTOSTART_DELAY, pendingIntent);
        }
	}
}
